import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.lang.Delegate;
import AutoComplete.trie;

/**
 * This class is a visual component. The entry point for class execution
 * is the constructor.
 */
public class toolbar extends UserControl
{
	/**
	 * user is making a call
	 */
	EventHandler m_Calling;
	private String lastChanged = "";
	private boolean inChangeText = false;

	/**
	 * trie for autocomplete
	 */
	private trie m_Wordstrie;
	/**
	 * user is making a call
	 */
	public void addOnCalling(EventHandler value)
	{
		m_Calling = (EventHandler)Delegate.combine(m_Calling, value);
	}

	/**
	 * trie for autocomplete
	 */
	public trie getWordstrie()
	{
		// TODO: Add your own implementation.
		return m_Wordstrie;
	}

	/**
	 * user is making a call
	 */
	protected void onCalling(Event event)
	{
		if (m_Calling != null) m_Calling.invoke(this, event);
	}

	/**
	 * user is making a call
	 */
	public void removeOnCalling(EventHandler value)
	{
		m_Calling = (EventHandler)Delegate.remove(m_Calling, value);
	}

	/**
	 * trie for autocomplete
	 */
	public void setWordstrie(trie value)
	{
		// TODO: Add your own implementation.
		m_Wordstrie = value;
	}
	
	public Object[] getComboBoxItems() {
		return comboBox2.getItems();
	}
	
	public void setComboBoxItems(Object[] param) {
		comboBox2.setItems(param);
	}

	public toolbar()
	{
		super();

		// Required for Visual J++ Form Designer support
		//
		initForm();

		// TODO: Add any constructor code after initForm call
		
		m_Wordstrie = new trie();
	}

	private void comboBox2_textChanged(Object source, Event e)
	{
		if(comboBox2.getText().equals(""))
			button1.setEnabled(false);
		else
			button1.setEnabled(true);
		if (inChangeText == true) return;
		inChangeText = true;
		String temp = comboBox2.getText();
		if(!temp.equals(lastChanged) && !temp.equals(comboBox2.getSelectedText())) {
			String ending = m_Wordstrie.getEnd(temp);
			if (ending != null) {
				comboBox2.setSelectionStart(temp.length());
				comboBox2.setSelectedText(ending);
				comboBox2.setSelectionStart(temp.length());
			}
		}
		lastChanged = temp;
		inChangeText = false;
	}

	private void comboBox2_keyPress(Object source, KeyPressEvent e)
	{
		Object[] items;
		String text;
		if(e.keyChar == Key.RETURN) {
			e.handled = true;
			text = comboBox2.getText();
			if(!text.equals("")) {
				items = comboBox2.getItems();
				boolean found = false;
				for(int i=0; i<items.length; i++) {
					if(((String)items[i]).equals(text)) {
						found = true;
						break;
					}
				}
				if(found == false) {
					comboBox2.addItem(text);
					m_Wordstrie.put(text,"");
				}
				m_Calling.invoke(source, new Event(new String(comboBox2.getText())));
			}
			comboBox2.setSelectionStart(0);
		} else if(e.keyChar == Key.BACK) {
			e.handled = true;
			inChangeText = true;
			comboBox2.setSelectedText("");
			String temp = comboBox2.getText();
			if(!temp.equals("")) {
				temp = temp.substring(0, temp.length()-1);
				comboBox2.setText(temp);
				comboBox2.setSelectionStart(temp.length());
			}
			inChangeText = false;
		}
	}

	private void button1_click(Object source, Event e)
	{
		comboBox2_keyPress(source,new KeyPressEvent((char)Key.RETURN));
	}

	/**
	 * NOTE: The following code is required by the Visual J++ form
	 * designer.  It can be modified using the form editor.  Do not
	 * modify it using the code editor.
	 */
	Container components = new Container();
	Button button1 = new Button();
	ComboBox comboBox2 = new ComboBox();

	private void initForm() { 
		this.setSize(new Point(350, 23));
		this.setText("toolbar");

		button1.setEnabled(false);
		button1.setLocation(new Point(208, 2));
		button1.setSize(new Point(88, 21));
		button1.setTabIndex(1);
		button1.setText("Call");
		button1.addOnClick(new EventHandler(this.button1_click));

		comboBox2.setLocation(new Point(1, 2));
		comboBox2.setSize(new Point(200, 21));
		comboBox2.setTabIndex(0);
		comboBox2.setText("");
		comboBox2.addOnKeyPress(new KeyPressEventHandler(this.comboBox2_keyPress));
		comboBox2.addOnTextChanged(new EventHandler(this.comboBox2_textChanged));

		this.setNewControls(new Control[] {
							comboBox2, 
							button1});
	}

	public static class ClassInfo extends UserControl.ClassInfo
	{
		// TODO: Add your property and event infos here
		public static final EventInfo calling = new EventInfo(
			toolbar.class, "calling", EventHandler.class,
			CategoryAttribute.Action,
			new DescriptionAttribute("user is making a call"));
		public static final PropertyInfo wordstrie = new PropertyInfo(
			toolbar.class, "wordstrie", trie.class,
			CategoryAttribute.Data,
			new DescriptionAttribute("trie for autocomplete"));
		public void getEvents(IEvents events)
		{
			super.getEvents(events);
			events.add(calling);
		}

		public void getProperties(IProperties props)
		{
			super.getProperties(props);
			props.add(wordstrie);
		}
	}
}
